local assets =
{
    Asset("ANIM", "anim/astchest.zip"),
    Asset("SOUND", "sound/common.fsb"),
	Asset("ATLAS", "images/inventoryimages/compressor.xml"),
	Asset("SOUND", "sound/chester.fsb"),
	
}

local prefabs =
{
    "seeds",
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddMiniMapEntity()
    inst.entity:AddNetwork()

    inst.AnimState:SetBank("astchest")
    inst.AnimState:SetBuild("astchest")
    inst.AnimState:PlayAnimation("idle")
MakeObstaclePhysics(inst, 1)
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
    inst:AddComponent("container")
    inst.components.container:WidgetSetup("astchest") 
    inst:AddComponent("inspectable")
	inst.Transform:SetScale(.7, .7, .7)

    ---------------------        
    ---------------------   
	inst.entity:AddDynamicShadow()
	inst.DynamicShadow:SetSize( 4,4 )
	MakeObstaclePhysics(inst, .2)
	

    return inst
end

return Prefab("astchest", fn, assets, prefabs),
MakePlacer("astchest_placer", "astchest", "astchest", "idle")